<form method="post" class="wpaieExportForm submitWPAIEForm" data-type="<?php echo $postType; ?>">
    <?php $this->showOutputResult($postType) ?>
    <div class="formControls">
        <div class="wpaie-heading">
            <span>Export 
                <?php
                if ($postType === "POST") {
                    echo "Post";
                }
                if ($postType === "PAGE") {
                    echo "Page";
                }
                ?>
                <?php _e( 'File', 'wpaie' ); ?></span>
        </div>  
        <div class="wpaie-control-group" <?php if ($postType === "POST" || $postType === "PAGE") echo "style=display:none;"; ?>>
            <label class="wpaie-control-label"> <?php _e( 'Select Post Type', 'wpaie' ); ?><span class="star">*</span></label>
            <div class="controls">
                <select class="small w-wrap" id="postType" name="postType">
                    <?php
                    if ($postType === "POST") {
                        echo "<option  selected='selected' value='POST'>POST</option>";
                    }
                    ?>
                    <?php
                    if ($postType === "PAGE") {
                        echo "<option  selected='selected' value='PAGE'>PAGE</option>";
                    }
                    foreach ($customPostTypes as $customPost) {
                        ?>
                        <option value="<?php echo $customPost; ?>"><?php echo $customPost; ?></option>
                    <?php } ?>
                </select>
            </div>
        </div>
        <div class="wpaie-control-group">
            <label class="wpaie-control-label"><?php _e( 'Select Post Columns', 'wpaie' ); ?><span class="star">*</span></label>
            <div class="controls">
                <select class="small w-wrap" id="postColumns<?php echo $postType; ?>" name="postColumns[]" multiple="multiple">
                    <?php
                    $idNotSelect = 0;
                    foreach ($postColumns as $column) {
                        if ($idNotSelect == 0)
                            echo '<option>' . $column . '</option>';
                        else
                            echo '<option selected="selected">' . $column . '</option>';
                        $idNotSelect++;
                    }
                    ?>
                </select>
            </div>
        </div>
        <div class="wpaie-control-group">
            <label class="wpaie-control-label"><?php _e( 'Select Post Meta', 'wpaie' ); ?></label>
            <div class="controls">
                <select class="small w-wrap" id="postMeta" name="postMeta[]" multiple="multiple" >
                <?php foreach ($metaFields as $fields) { ?>
                        <option><?php echo $fields; ?></option>
                <?php } ?>
                </select>
            </div>
        </div>
        <?php if ($postType != "PAGE") { ?>
            <div class="wpaie-control-group">
                <label class="wpaie-control-label"><?php _e( 'Select Taxonomies', 'wpaie' ); ?></label>
                <div class="controls">
                    <select class="small w-wrap" id="postCustomFields" name="postCustomFields[]" multiple="multiple" >
                        <option value="post_tag" selected="selected"><?php _e( 'Post Tags', 'wpaie' ); ?></option>
                        <option value="category" selected="selected"><?php _e( 'Post Category', 'wpaie' ); ?></option>
                        <?php foreach ($customFields as $fields) { ?>
                            <option><?php echo $fields; ?></option>
            <?php } ?>
                    </select>
                </div>
            </div>
        <?php } ?>
        <div class="wpaie-control-group">
            <label class="wpaie-control-label"><?php _e( 'Select Post Author', 'wpaie' ); ?></label>
            <div class="controls">
                <select class="small w-wrap" id="postAuthor" name="postAuthor[]" multiple="multiple" >
                <?php foreach ($postAutors as $author) { ?>
                    <option value="<?php echo $author->ID;?>"><?php echo $author->user_login; ?></option>
                <?php } ?>
                </select>
            </div>
        </div>
        <div class="wpaie-control-group">
            <label class="wpaie-control-label"><?php _e( 'Export Featured Image', 'wpaie' ); ?></label>
            <div class="controls">
                <select class="small w-wrap" id="exportFeaturedImg" name="exportFeaturedImg" >
                    <option value="true"><?php _e( 'Yes', 'wpaie' ); ?></option>
                    <option value="false"><?php _e( 'No', 'wpaie' ); ?></option>
                </select>
            </div>
        </div>
        <div class="wpaie-control-group">
            <label class="wpaie-control-label"><?php _e( 'No. Of Posts', 'wpaie' ); ?></label>
            <div class="controls">
                <select class="small w-wrap optionNoOfPost" id="optionNoOfPost" name="optionNoOfPost" data-type="<?php echo $postType; ?>" >
                    <option value="allposts"><?php _e( 'All Posts', 'wpaie' ); ?></option>
                    <option value="postrange"><?php _e( 'Post Range(Limit)', 'wpaie' ); ?></option>
                    <option value="postrangebypostid"><?php _e( 'Post Range(By post Id)', 'wpaie' ); ?></option>
                    <option value="specificpostbyid"><?php _e( 'Specific Post (By post Ids)', 'wpaie' ); ?></option>
                    <option value="postbydate"><?php _e( 'By Post Dates(YYYY-MM-DD format)', 'wpaie' ); ?></option>
                </select>
            </div>
        </div>
        <div class="wpaie-control-group postRange" style="display:none" data-type="<?php echo $postType; ?>">
            <label class="wpaie-control-label"></label>
            <div class="controls">
                <input type="text" id="postStartRange" name="postStartRange" placeholder="Start Post Id" />
                <input type="text" id="postTotalCount" name="postTotalCount" placeholder="Total Posts" />
            </div>
        </div>
        <div class="wpaie-control-group">
            <label class="wpaie-control-label"><?php _e( 'Post Status', 'wpaie' ); ?></label>
            <div class="controls">
                <select class="small w-wrap" id="postStatus" name="postStatus[]" multiple="multiple" >
                    <?php
                    foreach ($postStatus as $status) {
                        $selected = "";
                        if ($status == "publish")
                            $selected = "selected=selected";
                        ?>
                        <option <?php echo $selected; ?>><?php echo $status; ?></option>
                    <?php } ?>
                </select>
            </div>
        </div>
         <?php if ($postType == "POST") { ?>
            <div class="wpaie-control-group">
                <label class="wpaie-control-label"><?php _e( 'Select Post Category', 'wpaie' ); ?> </label>
                <div class="controls">
                    <select class="small w-wrap" id="postCats" name="postCats[]" multiple="multiple" >
                    <?php foreach ($postCats as $cat) { ?>
                        <option value="<?php echo $cat->term_id ;?>"><?php echo $cat->name; ?></option>
                    <?php } ?>
                    </select>
                </div>
            </div>
         <?php }?>
        <div class="wpaie-control-group">
            <label class="wpaie-control-label"><?php _e( 'Order By', 'wpaie' ); ?></label>
            <div class="controls">
                <input type="text" id="orderBy" name="orderBy" value="post_title"  />
            </div>
        </div>
        <div class="wpaie-control-group">
            <label class="wpaie-control-label"><?php _e( 'Order', 'wpaie' ); ?></label>
            <div class="controls">
                <select class="small w-wrap" id="orderAscDesc" name="orderAscDesc" >
                    <option value="ASC"><?php _e( 'ASC', 'wpaie' ); ?></option>
                    <option value="DESC"><?php _e( 'DESC', 'wpaie' ); ?></option>
                </select>
            </div>
        </div>
        <div class="wpaie-control-group">
            <label class="wpaie-control-label"><?php _e( 'Export as', 'wpaie' ); ?> </label>
            <div class="controls">
                <select class="small w-wrap" id="optionFileType" name="optionFileType" >
                    <option value="csv"><?php _e( 'CSV', 'wpaie' ); ?></option>
                    <option value="excel5"><?php _e( 'Excel 2003', 'wpaie' ); ?></option>
                    <option value="excel2007"><?php _e( 'Excel 2007', 'wpaie' ); ?></option>
                    <option value="pdf"><?php _e( 'PDF', 'wpaie' ); ?></option>
                    <option value="xml"><?php _e( 'XML', 'wpaie' ); ?></option>
                </select>
            </div>
        </div>
        <div class="wpaie-control-group">
            <div class="controls exportSubmit">
                <input type="hidden" value="<?php echo $postType; ?>" name="operationCategory" />
                <input type="submit" value="submit" name="submitExport" id="submitExport" class="submit" data-type="<?php echo $postType; ?>"  />
                <span id="processing<?php echo $postType; ?>" class="submit" style="display:none"><?php _e( 'Processing...', 'wpaie' ); ?></span>
                <?php
                if ($postType == 'POST')
                    echo '<input type="hidden" id="lastActivateTabId" name="lastActivateTabId" value="0"/>';
                if ($postType == 'PAGE')
                    echo '<input type="hidden" id="lastActivateTabId" name="lastActivateTabId" value="1"/>';
                if ($postType == 'CustomPost')
                    echo '<input type="hidden" id="lastActivateTabId" name="lastActivateTabId" value="6"/>';
                ?>
            </div>
        </div>
    </div>
</form>